<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleExpirySettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->getData())
            ->each(fn ($data) => Settings::make($data));
    }

    private function getData()
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Vehicles',
                'name' => 'Removed stock expiry',
                'config_key' => 'app-old-stock-expiry-days',
                'type' => 'int',
                'value' => 0,
                'superadmin' => true,
                'description' => 'Stock is kept with soft-delete flag for certain amount of days after removed. 0 value = follow system default',
                'order' => 1,
            ],
        ];
    }
}
