<?php

namespace App\Traits;

trait IconForType
{
    public function getIcon(string $type): string
    {
        return match ($type) {
            'message', 'textarea', 'text_area', 'editor' => 'font-case',
            'text', 'text_field' => 'text',
            'email', 'email_field' => 'at',
            'number', 'number_field' => 'hashtag',
            'date', 'datetime', 'date_field' => 'calendar-days',
            'file', 'file_upload' => 'file',
            'title' => 'heading',
            'image', 'image_upload' => 'image',
            'location', 'location_picker' => 'location-dot',
            'select', 'select_field' => 'list-dropdown',
            'boolean' => 'square-check',
            'checkbox', 'checkbox_list' => 'square',
            'yes_/_no' => 'square-check',
            'offer_id', 'offers', 'offer' => 'badge-dollar',
            'page_id', 'page', 'content_page' => 'file-lines',
            'vehicle_id' => 'car',
            'filter', 'vehicle' => 'cars',
            'custom' => 'input-pipe',
            'valuation' => 'money-bill',
            'form-field', 'options_field' => 'input-text',
            'button', 'submit_button', 'back_button' => 'play-pause',
            default => 'layer-group',
        };
    }
}
