<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class TestDriveEnquiryTypeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'General',
                'group' => 'Enquiries',
                'name' => 'Test Drive Form Enquiry Type Name',
                'config_key' => 'form-enquiry-type-test-drive',
                'type' => 'string',
                'value' => '',
            ],
        ];
    }
}
