<?php

namespace Tests\Tenant;

use Mtc\MercuryDataModels\Vehicle;
use Tests\TenantTestCase;
use Tests\UserForTenant;


class BulkDeleteControllerTest extends TenantTestCase
{
    use UserForTenant;

    /**
     * Test that multiple vehicles are successfully deleted.
     *
     * @return void
     */
    public function testItDeletesMultipleVehiclesSuccessfully()
    {

        $vehicles = Vehicle::factory()->count(3)->create();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->json('DELETE', route('tenant.bulk-delete'), [
                'model' => 'vehicles',
                'ids' => $vehicles->pluck('id')->toArray(),
            ]);

        $response->assertStatus(200);
        $response->assertJson(['message' => '3 records deleted successfully.']);
    }

    /**
     * Test that an error is returned for an invalid model.
     *
     * @return void
     */
    public function testItReturnsErrorForInvalidModel()
    {
        $vehicles = Vehicle::factory()->count(3)->create();

        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->json('DELETE', route('tenant.bulk-delete'), [
                'model' => 'invalidModel',
                'ids' => $vehicles->pluck('id')->toArray(),
            ]);

        $response->assertStatus(422);
        $response->assertJson([
            'errors' => [
                'model' => [
                    'The selected model is invalid.'
                ]
            ]
        ]);
    }

    /**
     * Test that an error is returned for missing vehicle IDs.
     *
     * @return void
     */
    public function testItReturnsErrorForMissingIds()
    {
        $response = $this->actingAs($this->getUser())
            ->withHeader('X-Tenant', tenant('id'))
            ->json('DELETE', route('tenant.bulk-delete'), [
                'model' => 'vehicles',
            ]);

        $response->assertStatus(422);
        $response->assertJson([
            'errors' => [
                'ids' => ['The ids field is required.']
            ]
        ]);
    }
}
