<?php

namespace Tests\Feature;

use App\Actions\IntegrationVerification\VerifyAutoTraderPartEx;
use App\Actions\IntegrationVerification\VerifyAutoTraderSpecs;
use App\Actions\IntegrationVerification\VerifyCampaignMonitor;
use App\Actions\IntegrationVerification\VerifyCapPartEx;
use App\Actions\IntegrationVerification\VerifyCapSpecs;
use App\Actions\IntegrationVerification\VerifyCodeWeavers;
use App\Actions\IntegrationVerification\VerifyDmsNavigator;
use App\Actions\IntegrationVerification\VerifyEnquiryMax;
use App\Actions\IntegrationVerification\VerifyEvolutionFunding;
use App\Actions\IntegrationVerification\VerifyIvendi;
use App\Actions\IntegrationVerification\VerifyMailChimp;
use App\Actions\IntegrationVerification\VerifyMailServer;
use App\Actions\IntegrationVerification\VerifyPinewood;
use App\Actions\IntegrationVerification\VerifyRapidRtc;
use App\Actions\IntegrationVerification\VerifySilverBullet;
use App\Traits\TrackedSeeding;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Http;
use Tests\TestCase;
use Tests\UserForTenant;

class VerificationTest extends TestCase
{
    use DatabaseMigrations;
    use UserForTenant;
    use TrackedSeeding;

    protected $tenancy = true;

    public function testTrackedSeed()
    {
        Http::fake([
            "*" => Http::response([], 200),
        ]);
        $this->assertTrue(App::make(VerifyAutoTraderPartEx::class)->verify());
        $this->assertTrue(App::make(VerifyAutoTraderSpecs::class)->verify());
        $this->assertTrue(App::make(VerifyCampaignMonitor::class)->verify());
        $this->assertTrue(App::make(VerifyCapPartEx::class)->verify());
        $this->assertTrue(App::make(VerifyCodeWeavers::class)->verify());
        $this->assertTrue(App::make(VerifyEnquiryMax::class)->verify());
        $this->assertTrue(App::make(VerifyEvolutionFunding::class)->verify());
        $this->assertTrue(App::make(VerifyIvendi::class)->verify());
        $this->assertTrue(App::make(VerifyMailChimp::class)->verify());
        $this->assertTrue(App::make(VerifyMailServer::class)->verify());
        $this->assertTrue(App::make(VerifyRapidRtc::class)->verify());
        $this->assertTrue(App::make(VerifySilverBullet::class)->verify());

        $this->assertInstanceOf(Response::class, App::make(VerifyDmsNavigator::class)->verify());
        $this->assertInstanceOf(Response::class,App::make(VerifyPinewood::class)->verify());
    }

}
