<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;
use Mtc\MercuryDataModels\SeoDefault;

class SeoSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->settings())
            ->each(fn($setting) => Settings::make($setting));

        collect($this->defaults())
            ->each(fn($default) => SeoDefault::query()->updateOrCreate(['section' => $default['section']], $default));
    }

    private function settings(): array
    {
        return [
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Analytics',
                'name' => 'Google Analytics ID',
                'config_key' => 'seo-ga_id',
                'type' => 'string',
                'value' => '',
                'description' => '"UA-00000000-1" code. Allows implementing '
                    . '<a href="https://support.google.com/analytics/answer/6086070?hl=en" target="_blank">'
                    . 'Google Analytics</a> tracking.',
            ],
            [
                'tab' => 'Site',
                'section' => 'SEO',
                'group' => 'Analytics',
                'name' => 'Google Tag Manager ID',
                'config_key' => 'seo-gtm_id',
                'type' => 'string',
                'value' => '',
                'description' => '"GTM-XXXXXXX" code. Allows implementing '
                    . '<a href="https://support.google.com/tagmanager/answer/6102821?hl=en" '
                    . 'target="_blank">Google Tag Manager</a> features.',
            ],
        ];
    }

    private function defaults(): array
    {
        return [
            [
                'section' => 'page',
                'title' => '{{TITLE}} | {{SITE_NAME}}',
                'description' => '{{CONTENT_EXCERPT}}',
            ],
            [
                'section' => 'dealership',
                'title' => '{{TITLE}} | {{SITE_NAME}}',
                'description' => '',
            ],
            [
                'section' => 'offer',
                'title' => '{{TITLE}} | {{MAKE}} Offers | {{SITE_NAME}} ',
                'description' => '{{CONTENT_EXCERPT}}',
            ],
            [
                'section' => 'filter',
                'title' => '{{BODY_STYLE}} {{MAKE}} {{MODEL}} Used Vehicle Offers | Page {{PAGE}} | {{SITE_NAME}}',
                'description' => '',
            ],
            [
                'section' => 'offers',
                'title' => '{{BODY_STYLE}} {{MAKE}} {{MODEL}} New Vehicle Offers | {{SITE_NAME}}',
                'description' => '',
            ],
            [
                'section' => 'vehicle',
                'title' => '{{TITLE}} | {{MAKE}} Offers | {{SITE_NAME}} ',
                'description' => '{{CONTENT_EXCERPT}}',
            ],
        ];
    }
}
