<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleSortByOldestFilterSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'Sorting',
                'name' => 'Oldest Additions',
                'config_key' => 'automotive-vehicle-sorting-oldest',
                'type' => 'boolean',
                'value' => false,
                'order' => 44,
            ],
        ];
    }
}
