<?php

namespace Tests\Tenant;

use App\Http\Resources\EnquiryViewResource;
use Mtc\Crm\Models\FormQuestion;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\Enquiry;
use Mtc\MercuryDataModels\Form;
use Tests\TenantTestCase;

class EnquiryViewResourceTest extends TenantTestCase
{
    public function testDataSourceDealershipExists()
    {
        $dealership = Dealership::factory()->create(['name' => 'foo']);
        $form = Form::factory()->create();
        $question = FormQuestion::factory()->create([
            'form_id' =>$form->id,
            'data' => [
                'meta' => [
                    'options' => [
                        'source' => 'dealerships'
                    ]
                ],
            ]
        ]);

        $enquiry = Enquiry::factory()->create([
            'form_id' => $form->id,
            'details' => [
                [
                    'id' => $question->id,
                    'question' => 'foo faz fal',
                    'answer' => $dealership->id,
                ]
            ]
        ]);
        // need to reload because Factory returns package based object that does not have some relationships
        $enquiry = Enquiry::query()->find($enquiry->id);

        $resource = (new EnquiryViewResource($enquiry))->toArray(request());
        $this->assertEquals('foo', $resource['details'][0]['value']);
    }

    public function testDataSourceDealershipDoesNotExist()
    {
        $form = Form::factory()->create();
        $question = FormQuestion::factory()->create([
            'form_id' =>$form->id,
            'data' => [
                'meta' => [
                    'options' => [
                        'source' => 'dealerships'
                    ]
                ],
            ]
        ]);

        $enquiry = Enquiry::factory()->create([
            'form_id' => $form->id,
            'details' => [
                [
                    'id' => $question->id,
                    'question' => 'foo faz fal',
                    'answer' => 999,
                ]
            ]
        ]);
        // need to reload because Factory returns package based object that does not have some relationships
        $enquiry = Enquiry::query()->find($enquiry->id);

        $resource = (new EnquiryViewResource($enquiry))->toArray(request());
        $this->assertEquals('Unknown', $resource['details'][0]['value']);
    }
}
