<?php

namespace Tests\Tenant;

use App\VehicleAttributeRepository;
use Mtc\MercuryDataModels\VehicleAttribute;
use Tests\TenantTestCase;

class VehicleAttributeRepositoryTest extends TenantTestCase
{
    public function testImportRecord()
    {
        $repository = new VehicleAttributeRepository();
        $this->assertEquals(0, VehicleAttribute::query()->count());
        $this->assertTrue($repository->importRecord([
            'name' => 'foo',
            'type' => 'string',
            'slug' => 'foo',
            'sortable' => true,
            'filterable' => true,
        ]));

        $this->assertEquals(1, VehicleAttribute::query()->count());
        $attribute = VehicleAttribute::query()->first();
        $this->assertEquals(1, $attribute->sortable);
        $this->assertEquals(1, $attribute->filterable);
        $this->assertEquals('foo', $attribute->name);
        $this->assertEquals('foo', $attribute->slug);
        $this->assertEquals('string', $attribute->type);
    }

    public function testCanBeImported()
    {
        $repository = new VehicleAttributeRepository();
        $this->assertTrue($repository->canBeImported([
            'slug' => 'foo',
        ]));

        VehicleAttribute::query()->create([
            'name' => 'foo',
            'type' => 'string',
            'slug' => 'foo',
            'sortable' => true,
            'filterable' => true,
        ]);

        $this->assertFalse($repository->canBeImported([
            'slug' => 'foo',
        ]));
    }

    public function testExportToRemote()
    {
        $repository = new VehicleAttributeRepository();

        $entries = VehicleAttribute::factory(5)->create();
        $result = $repository->exportToRemote($entries->pluck('id')->toArray());
        $this->assertEquals(5, count($result));
        $this->assertArrayHasKey('name', $result[0]);
        $this->assertArrayHasKey('slug', $result[0]);
        $this->assertArrayHasKey('type', $result[0]);
        $this->assertArrayHasKey('validation', $result[0]);
        $this->assertArrayHasKey('count', $result[0]);
        $this->assertArrayHasKey('data', $result[0]);
        $this->assertArrayHasKey('order', $result[0]);
    }

    public function testCheckImportEntryValidity()
    {
        $repository = new VehicleAttributeRepository();
        $result = $repository->checkImportEntryValidity([
            'slug' => 'foo',
        ], []);
        $this->assertEmpty($result['errors']);

        $result = $repository->checkImportEntryValidity([
            'slug' => null,
        ], []);
        $this->assertNotEmpty($result['errors']);

        VehicleAttribute::query()->create([
            'name' => 'foo',
            'type' => 'string',
            'slug' => 'foo',
            'sortable' => true,
            'filterable' => true,
        ]);

        $result = $repository->checkImportEntryValidity([
            'slug' => 'foo',
        ], []);
        $this->assertNotEmpty($result['errors']);

    }
}
