<?php

namespace Database\Seeders\Global;

use Illuminate\Database\Seeder;
use App\Models\ExportMapTemplate;

class ExportMapTemplatesSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        ExportMapTemplate::updateOrCreate(
            [
                'title' => 'Modix export',
            ],
            [
                'is_published' => true,
                'sales_channel' => '',
                'type' => 'vehicle',
                'columns' => [
                    "custom2",
                    "uuid",
                    "vrm_condensed",
                    "vin",
                    "cap_id",
                    "model.name",
                    "trim",
                    "description",
                    "empty",
                    "colour",
                    "empty",
                    "empty",
                    "empty",
                    "type",
                    "bodyStyle.name",
                    "transmission.name",
                    "odometer_mi",
                    "condition",
                    "custom1",
                    "empty",
                    "empty",
                    "first_registration_date",
                    "available_date",
                    "empty",
                    "created_at",
                    "updated_at",
                    "rrp_price",
                    "price",
                    "reservation_amount",
                    "is_vat_applicable",
                    "standardEquipment.description",
                    "optionalEquipment.description",
                    "attention_grabber",
                    "images"
                ],
                'headers' => [
                    "Feed_ID",
                    "Vehicle_ID",
                    "FullRegistration",
                    "VIN",
                    "CapCode",
                    "ModelRange",
                    "Trim",
                    "Description",
                    "PaintType",
                    "PrimaryColour",
                    "ManufacturerColour",
                    "InteriorColour",
                    "InteriorMaterial",
                    "VehicleType",
                    "BodyType",
                    "Transmission",
                    "Mileage",
                    "VehicleCondition",
                    "ServiceHistory",
                    "Approved",
                    "OnlineReservable",
                    "FirstRegistration",
                    "Availability",
                    "Warranty",
                    "Creation",
                    "Modified",
                    "RetailPrice",
                    "TradePrice",
                    "ReservePrice",
                    "VATType",
                    "StandardEquipment",
                    "OptionalEquipment",
                    "AttentionGrabber",
                    "ImageLinks"
                ],
                'mapping_rules' => [
                    [
                        "when" => [
                            "field" => "type",
                            "op" => "eq",
                            "value" => "LCV"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "cap_id",
                                "value" => null
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "is_vat_applicable",
                            "op" => "eq",
                            "value" => "Y"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "is_vat_applicable",
                                "value" => "VAT Qualifying"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "is_vat_applicable",
                            "op" => "eq",
                            "value" => "N"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "is_vat_applicable",
                                "value" => "Non VAT Qualifying"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "uuid",
                            "op" => "is_not_empty",
                            "value" => null
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "custom1",
                                "value" => "Not Known"
                            ],
                            [
                                "action" => "set",
                                "target" => "custom2",
                                "value" => "feed_id"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "type",
                            "op" => "eq",
                            "value" => "car"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "type",
                                "value" => "Passenger"
                            ]
                        ]
                    ]
                ],
            ]
        );

        ExportMapTemplate::updateOrCreate(
            [
                'title' => 'CarWow',
            ],
            [
                'is_published' => true,
                'sales_channel' => 'car-wow',
                'type' => 'vehicle',
                'columns' => [
                    "registration_number",
                    "uuid",
                    "make.name",
                    "model.name",
                    "derivative",
                    "colour",
                    "vin",
                    "manufacture_year",
                    "derivative",
                    "price",
                    "custom1",
                    "odometer_mi",
                    "cap_code",
                    "cap_id",
                    "bodyStyle.name",
                    "transmission.name",
                    "empty",
                    "uuid",
                    "transmission.name",
                    "dealership.data.car-wow-dealer-id",
                    "dealership.name",
                    "dealership.address1",
                    "dealership.county",
                    "dealership.postcode",
                    "dealership.email",
                    "first_registration_date",
                    "is_new",
                    "door_count",
                    "engine_size_cc",
                    "fuelType.name",
                    "empty",
                    "images"
                ],
                'headers' => [
                    "registration",
                    "external_id",
                    "make",
                    "model",
                    "derivative",
                    "exterior_colour",
                    "vin",
                    "year",
                    "variant",
                    "price",
                    "vat_included",
                    "mileage",
                    "cap_code",
                    "cap_id",
                    "body",
                    "transmission",
                    "comments",
                    "stock_number",
                    "gearbox",
                    "dealer_id",
                    "dealer_name",
                    "dealer_street_address",
                    "dealer_county",
                    "dealer_postcode",
                    "dealer_crm_email",
                    "registration_date",
                    "is_new",
                    "doors",
                    "engine_size",
                    "fuel_type",
                    "video",
                    "images"
                ],
                'mapping_rules' => [
                    [
                        "when" => [
                            "field" => "is_new",
                            "op" => "eq",
                            "value" => "Y"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "is_new",
                                "value" => "1"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "is_new",
                            "op" => "eq",
                            "value" => "N"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "is_new",
                                "value" => "0"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "type",
                            "op" => "eq",
                            "value" => "Car"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "custom1",
                                "value" => "1"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "type",
                            "op" => "neq",
                            "value" => "Car"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "custom1",
                                "value" => "0"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "type",
                            "op" => "eq",
                            "value" => "LCV"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "cap_id",
                                "value" => null
                            ]
                        ]
                    ],
                ],
            ]
        );

        ExportMapTemplate::updateOrCreate(
            [
                'title' => 'AutoWeb',
            ],
            [
                'is_published' => true,
                'sales_channel' => 'autoweb',
                'type' => 'vehicle',
                'columns' => [
                    "custom1",
                    "uuid",
                    "vrm_condensed",
                    "cap_id",
                    "make.name",
                    "model.name",
                    "derivative",
                    "manufacture_year",
                    "price",
                    "odometer_mi",
                    "colour",
                    "fuelType.name",
                    "first_registration_date",
                    "door_count",
                    "engine_size_cc",
                    "transmission.name",
                    "description",
                    "equipment.description",
                    "dealership.data.autoweb-dealer-id",
                    "dealership.name",
                    "dealership.address1",
                    "dealership.county",
                    "dealership.postcode",
                    "dealership.email",
                    "images",
                ],
                'headers' => [
                    "Feed_Id",
                    "Vehicle_Id",
                    "FullRegistration",
                    "Cap_Id",
                    "Make",
                    "Model",
                    "Variant",
                    "Year",
                    "Price",
                    "Mileage",
                    "Colour",
                    "FuelType",
                    "Registration_Date",
                    "Doors",
                    "EngineSize",
                    "Transmission",
                    "Description",
                    "Options",
                    "Dealer_Id",
                    "Dealer_Name",
                    "Dealer_Street_Address",
                    "Dealer_County",
                    "Dealer_Postcode",
                    "Dealer_Crm_Email",
                    "PictureRefs",
                ],
                'mapping_rules' => [
                    [
                        "when" => [
                            "field" => "uuid",
                            "op" => "is_not_empty",
                            "value" => null
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "custom1",
                                "value" => "feed_id"
                            ]
                        ]
                    ],
                ],
            ]
        );

        ExportMapTemplate::updateOrCreate(
            [
                'title' => 'CarGuru',
            ],
            [
                'is_published' => true,
                'sales_channel' => 'car-gurus',
                'type' => 'vehicle',
                'columns' => [
                    "vrm_condensed",
                    "make.name",
                    "model.name",
                    "empty",
                    "derivative",
                    "price",
                    "odometer_mi",
                    "images",
                    "colour",
                    "empty",
                    "uuid",
                    "transmission.name",
                    "specs.description",
                    "dealership.data.car-guru-dealer-id",
                    "dealership.name",
                    "dealership.address1",
                    "dealership.county",
                    "dealership.postcode",
                    "dealership.email",
                    "first_registration_date",
                    "is_new",
                    "door_count",
                    "engine_size_cc",
                    "fuelType.name",
                    "custom1",
                ],
                'headers' => [
                    "vrm",
                    "make",
                    "model",
                    "year",
                    "variant",
                    "price",
                    "mileage",
                    "image_urls",
                    "colour",
                    "comments",
                    "stock_number",
                    "gearbox",
                    "installed_options",
                    "dealer_id",
                    "dealer_name",
                    "dealer_street_address",
                    "dealer_county",
                    "dealer_postcode",
                    "dealer_crm_email",
                    "registration_date",
                    "is_new",
                    "doors",
                    "engine_size",
                    "fuel_type",
                    "plus_vat",
                ],
                'mapping_rules' => [
                    [
                        "when" => [
                            "field" => "is_new",
                            "op" => "eq",
                            "value" => "Y"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "is_new",
                                "value" => "1"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "is_new",
                            "op" => "eq",
                            "value" => "N"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "is_new",
                                "value" => "0"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "type",
                            "op" => "eq",
                            "value" => "LCV"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "custom1",
                                "value" => "0"
                            ]
                        ]
                    ],
                    [
                        "when" => [
                            "field" => "type",
                            "op" => "neq",
                            "value" => "LCV"
                        ],
                        "then" => [
                            [
                                "action" => "set",
                                "target" => "custom1",
                                "value" => "1"
                            ]
                        ]
                    ]
                ],
            ]
        );
    }
}
