<?php

namespace App\Contracts;

use Illuminate\Contracts\Support\Arrayable;

abstract class ReportTile implements Arrayable
{
    abstract public function name(): string;

    abstract public function value(): mixed;

    abstract public function subtitle(): string;

    abstract public function difference(): mixed;

    public function differenceType(): string
    {
        $diff = $this->value() - $this->secondaryValue();
        if ($diff > 0) {
            return 'positive';
        }
        return $diff < 0
            ? 'negative'
            : 'noChange';
    }

    abstract public function secondaryValue(): mixed;

    abstract public function secondaryValueName(): string;

    public function toArray()
    {
        return [
            'name' => $this->name(),
            'value' => $this->value(),
            'subtitle' => $this->subtitle(),
            'difference' => $this->difference(),
            'diff_type' => $this->differenceType(),
            'secondary_value' => $this->secondaryValue(),
            'secondary_name' => $this->secondaryValueName(),
        ];
    }
}
