<?php

namespace App\Crm\Config;

use App\Facades\Settings;

class SalesforceCrmConfig
{
    public function enabled(): bool
    {
        return (bool) Settings::get('salesforce-crm-enabled');
    }

    public function username(): ?string
    {
        return Settings::get('salesforce-crm-username');
    }

    public function password(): ?string
    {
        return Settings::get('salesforce-crm-password');
    }

    public function clientId(): ?string
    {
        return Settings::get('salesforce-crm-client-id');
    }

    public function clientSecret(): ?string
    {
        return Settings::get('salesforce-crm-client-secret');
    }

    public function feedSource(): ?string
    {
        return Settings::get('salesforce-crm-feedsource');
    }

    public function testDriveBookingTimeAnytime()
    {
        return Settings::get('salesforce-crm-booking-time-anytime', '00:00:00');
    }

    public function testDriveBookingTimeMorning()
    {
        return Settings::get('salesforce-crm-booking-time-morning', '10:00:00');
    }

    public function testDriveBookingTimeAfternoon()
    {
        return Settings::get('salesforce-crm-booking-time-afternoon', '13:00:00');
    }

    public function testDriveBookingTimeEvening()
    {
        return Settings::get('salesforce-crm-booking-time-evening', '16:00:00');
    }
}
