<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ModixSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Modix',
                'name' => 'Enabled',
                'config_key' => 'stock-modix-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => 'Retrieve stock through FTP that is passed from Modix',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Modix',
                'name' => 'FTP Host',
                'config_key' => 'stock-modix-ftp-host',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Modix',
                'name' => 'FTP Username',
                'config_key' => 'stock-modix-ftp-username',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Modix',
                'name' => 'FTP Password',
                'config_key' => 'stock-modix-ftp-password',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'DMS vehicle sync',
                'group' => 'Modix',
                'name' => 'Path to archive',
                'config_key' => 'stock-modix-archive-path',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'description' => 'Path to the stock archive on FTP server'
            ],
        ];
    }
}
