<?php

namespace App\Mail;

use App\TaxonomyMap;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewUnmappedTaxonomyMail extends Mailable
{
    use Queueable;
    use SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(private readonly TaxonomyMap $taxonomyMap)
    {
        //
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('system.new_taxonomy', [
            'taxonomy' => $this->taxonomyMap,
        ]);
    }
}
