<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class LiveChatSeezarSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Seezar',
                'name' => 'Enabled',
                'config_key' => 'chat-seezar-enabled',
                'type' => 'boolean',
                'value' => false,
                'order' => 0,
                'description' => '<a href="https://www.seezar.ai/" target="_blank">Seezar</a> AI chat integration.'
            ],
            [
                'tab' => 'CRM',
                'section' => 'Live Chat',
                'group' => 'Seezar',
                'name' => 'Client ID',
                'config_key' => 'chat-seezar-client-id',
                'type' => 'string',
                'value' => '',
                'order' => 1,
                'description' => 'Seezar live chat client ID.',
                'validation_rules' => [
                    "required_if:values.chat-seezar-enabled,true"
                ]
            ],
        ];
    }
}
