<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class MailThemeSettingSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Site',
            'section' => 'Mail',
            'group' => 'Contact Details',
            'name' => 'Email Theme',
            'config_key' => 'mail-customer-theme',
            'type' => 'string',
            'value' => 'default',
            'superadmin' => true,
            'min_tier' => 'lite',
            'description' => 'Set the name of the custom email theme for customer facing emails.'
                . ' Leave as default if no custom theme',
            'order' => 130,
        ]);
    }
}
