<?php

namespace App\Crm;

use App\Contracts\ForwardsReservationToCrm;
use App\Contracts\ForwardsServiceBookingToCrm;
use App\Facades\Settings;
use App\Services\PinewoodCrmApi;
use Mtc\Crm\Contracts\EnquiryAction;
use Mtc\Crm\Contracts\EnquiryActionModel;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\MercuryDataModels\Booking;
use Mtc\VehicleReservations\Reservation;

class SendEnquiryToPinewood implements EnquiryAction, ForwardsReservationToCrm, ForwardsServiceBookingToCrm
{
    use CheckForExpiredAction;

    public function __construct(private readonly PinewoodCrmApi $api)
    {
        //
    }

    public function enabled(): bool
    {
        return Settings::get('pinewood-crm-enabled') === true;
    }

    /**
     * Data fields to add to form
     *
     * @return array
     */
    public function formAdditionalDataFields(): array
    {
        return [];
    }

    /**
     * Data fields to add to questions
     *
     * @return array[]
     */
    public function formQuestionDataFields(): array
    {
        return [
            'pinewood-field' => [
                'type' => 'select',
                'label' => 'Field mapped against Pinewood CRM',
                'choices' => [
                    'title' => 'Title',
                    'first_name' => 'Forename',
                    'last_name' => 'Surname',
                    'company_name' => 'Company Name',
                    'phone' => 'Mobile Phone Number',
                    'email' => 'Email Address',
                    'notes' => 'Message/Comments',


                    'address1' => 'Address Line 1',
                    'address2' => 'Address Line 2',
                    'address3' => 'Address Line 3',
                    'city' => 'City',
                    'county' => 'County',
                    'postcode' => 'Postcode',
                    'Country' => 'Country',

                    'preferredContactMethods' => 'Preferred means of contact',
                ],
            ]
        ];
    }

    /**
     * Handle the action
     *
     * @param EnquiryActionModel $action
     * @param EnquiryModel $enquiry
     * @return bool
     */
    public function handle(EnquiryActionModel $action, EnquiryModel $enquiry): ?bool
    {
        if ($this->expired($action)) {
            return null;
        }

        return $this->api->sendLead($enquiry, $action);
    }

    public function sendReservation(Reservation $reservation): bool
    {
        return $this->api->sendReservation($reservation);
    }

    /**
     * Message when successfully processed
     *
     * @return string
     */
    public function successDetails(): string
    {
        return __('crm.lead_registered_with_reference', [
            'reference' => $this->api->getResponseAttribute('Lead_UID'),
        ]);
    }

    /**
     * Message when failure detected
     *
     * @return string
     */
    public function failureReason(): string
    {
        return $this->api->getResponseAttribute('') ?? 'Unknown error';
    }

    public function sendServiceBooking(Booking $booking): bool
    {
        return $this->api->sendServiceBooking($booking);
    }
}
