<?php

namespace App\Crm;

use App\Contracts\AddsDealershipFields;
use App\Contracts\ForwardsReservationToCrm;
use App\Facades\Settings;
use App\Services\DealerWebLmsApi;
use App\Services\FuseCrmApi;
use Illuminate\Support\Facades\App;
use Mtc\Crm\Contracts\EnquiryAction;
use Mtc\Crm\Contracts\EnquiryActionModel;
use Mtc\Crm\Contracts\EnquiryModel;
use Mtc\VehicleReservations\Reservation;

class StormMSDynamics implements EnquiryAction, AddsDealershipFields
{
    use CheckForExpiredAction;

    public function __construct()
    {
        //
    }

    public function enabled(): bool
    {
        return Settings::get('storm-ms-dynamics-crm-enabled') === true;
    }

    /**
     * Data fields to add to form
     *
     * @return array
     */
    public function formAdditionalDataFields(): array
    {
        return [];
    }

    /**
     * Data fields to add to questions
     *
     * @return array[]
     */
    public function formQuestionDataFields(): array
    {
        return [
            'ms-dynamics-field' => [
                'type' => 'select',
                'label' => 'Field mapped against MS Dynamics',
                'choices' => [
                    'title' => 'Title',
                    'first_name' => 'First Name',
                    'last_name' => 'Last Name',

                    'phone' => 'Mobile Phone Number',
                    'email' => 'Email Address',
                    'message' => 'Message/Comments',

                    'building_ext' => 'Building ext',
                    'building_int' => 'Building int',
                    'country_code' => 'Country (Code)',
                    'district' => 'District',
                    'postcode' => 'Postcode',
                    'primary_locality' => 'Primary locality',
                    'secondary_locality' => 'Secondary locality',
                    'street' => 'Street',

                    'preferred_date' => 'Preferred booking date',
                    'preferred_date_approximate' => 'Preferred booking time of day (approximate)',

                    'contact_methods' => 'Preferred means of contact',
                    'source_url' => 'External URL for additional vehicle details (must start with https://)',
                ],
            ]
        ];
    }

    public function dealershipAdditionalDataFields(): array
    {
        return [
            'ms-dynamics-dealership' => [
                'type' => 'text',
                'label' => 'Dealership hash for link with MS Dynamics'
            ],
        ];
    }


    public function handle(EnquiryActionModel $action, EnquiryModel $enquiry): ?bool
    {
        return true;
    }

    public function successDetails(): string
    {
        return 'Available on API endpoint';
    }

    public function failureReason(): string
    {
        return '';
    }
}
