<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class BrevoSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Brevo',
                'name' => 'Enabled',
                'config_key' => 'brevo-crm-enabled',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Integrations',
                'group' => 'Brevo',
                'name' => 'API Key',
                'config_key' => 'brevo-api-key',
                'type' => 'string',
                'value' => '',
                'validation_rules' => [
                    "required_if:values.brevo-crm-enabled,true"
                ]
            ],
        ];
    }
}
