<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class SilverBulletReserveCostSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Sales',
            'group' => 'Keyloop Ecommerce',
            'name' => 'Reserve button text',
            'config_key' => 'sales-silver-bullet-reserve-button-text',
            'type' => 'string',
            'value' => 'Reserve for :amount',
            'description' => 'Add :amount value to allow per-dealership costs',
            'order' => 15,
        ]);
        Settings::make([
            'tab' => 'Automotive',
            'section' => 'Sales',
            'group' => 'Keyloop Ecommerce',
            'name' => 'Reserve button price',
            'config_key' => 'sales-silver-bullet-reserve-cost',
            'description' => 'Price set as :amount unless specified differently in dealership',
            'type' => 'string',
            'value' => '',
            'order' => 15,
        ]);
    }

}
