<?php

namespace App\Enums;

enum MappingOperator: string
{
    case EQ = 'eq';
    case NEQ = 'neq';
    case IN = 'in';
    case NOT_IN = 'not_in';
    case CONTAINS = 'contains';
    case STARTS_WITH = 'starts_with';
    case ENDS_WITH = 'ends_with';
    case GT = 'gt';
    case GTE = 'gte';
    case LT = 'lt';
    case LTE = 'lte';
    case IS_EMPTY = 'is_empty';
    case IS_NOT_EMPTY = 'is_not_empty';

    public static function values(): array
    {
        return array_map(static fn(self $operator) => $operator->value, self::cases());
    }

    public static function withoutValue(): array
    {
        return [self::IS_EMPTY->value, self::IS_NOT_EMPTY->value];
    }

    public static function fromString(?string $operatorString): ?self
    {
        return $operatorString ? self::tryFrom($operatorString) : null;
    }

    public function expectsValue(): bool
    {
        return !in_array($this, [self::IS_EMPTY, self::IS_NOT_EMPTY], true);
    }

    public function isNumeric(): bool
    {
        return in_array($this, [self::GT, self::GTE, self::LT, self::LTE], true);
    }
}
