<?php

namespace App\Master\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class ApiToken extends Model
{
    use CentralConnection;
    use HasFactory;

    public const TYPE_PERSISTENT = 'persistent';
    public const TYPE_OAUTH = 'oauth';

    protected $fillable = [
        'api_user_id',
        'token',
        'token_type',
        'expires_at',
    ];

    protected $casts = [
        'expires_at' => 'datetime:Y-m-d H:i'
    ];

    protected $appends = [
        'expires_in_days',
    ];

    protected static function newFactory()
    {
    }

    public function apiUser(): BelongsTo
    {
        return $this->belongsTo(ApiUser::class);
    }

    public function getExpiresInDaysAttribute()
    {
        return Carbon::now()->diffInDays($this->expires_at, false);
    }
}
