<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class NewsletterSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'CRM',
                'section' => 'Newsletter',
                'group' => 'Mailchimp',
                'name' => 'Enabled',
                'config_key' => 'newsletters-mailchimp-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => '<a href="https://mailchimp.com/" target="_blank">MailChimp</a> integration. '
                    . 'Send newsletter signups to MailChimp signup list.',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Newsletter',
                'group' => 'Mailchimp',
                'name' => 'API Key',
                'config_key' => 'newsletters-mailchimp-api_key',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'description' => '<a href="https://mailchimp.com/help/about-api-keys/" target="_blank">Where to find API key</a>',
                'validation_rules' => [
                    "required_if:values.newsletters-mailchimp-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Newsletter',
                'group' => 'Mailchimp',
                'name' => 'List ID',
                'config_key' => 'newsletters-mailchimp-list_id',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'description' => '<a href="https://mailchimp.com/help/find-audience-id/" target="_blank">How to find list/audience ID</a>',
                'validation_rules' => [
                    "required_if:values.newsletters-mailchimp-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Newsletter',
                'group' => 'Mailchimp',
                'name' => 'Verify integration',
                'config_key' => 'newsletters-mailchimp-verify',
                'type' => 'verify',
                'min_tier' => 'standard',
                'value' => false,
            ],
            [
                'tab' => 'CRM',
                'section' => 'Newsletter',
                'group' => 'CampaignMonitor',
                'name' => 'Enabled',
                'config_key' => 'newsletters-campaign-monitor-enabled',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => false,
                'description' => '<a href="https://www.campaignmonitor.com/" target="_blank">Campaign Monitor</a> integration. '
                    . 'Send newsletter signups to Campaign Monitor signup list.',
            ],
            [
                'tab' => 'CRM',
                'section' => 'Newsletter',
                'group' => 'CampaignMonitor',
                'name' => 'API Key',
                'config_key' => 'newsletters-campaign-monitor-api_key',
                'type' => 'secret',
                'min_tier' => 'standard',
                'value' => '',
                'description' => '<a href="https://help.campaignmonitor.com/api-keys" target="_blank">How to find API key</a>',
                'validation_rules' => [
                    "required_if:values.newsletters-campaign-monitor-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Newsletter',
                'group' => 'CampaignMonitor',
                'name' => 'List ID',
                'config_key' => 'newsletters-campaign-monitor-list_id',
                'type' => 'string',
                'min_tier' => 'standard',
                'value' => '',
                'description' => 'Lists and Subscribers in top menu > Select list > change name/type > API Subscriber List ID',
                'validation_rules' => [
                    "required_if:values.newsletters-campaign-monitor-enabled,true"
                ]
            ],
            [
                'tab' => 'CRM',
                'section' => 'Newsletter',
                'group' => 'CampaignMonitor',
                'name' => 'Verify integration',
                'config_key' => 'newsletters-campaign-monitor-verify',
                'type' => 'verify',
                'min_tier' => 'standard',
                'value' => false,
            ],
        ];
    }
}
