@php
$new_cars_url = \App\Facades\Site::url('/new-cars');
$used_cars_url = \App\Facades\Site::url('/used-cars');
$valuation_url = \App\Facades\Site::url('/valuation');
$vehicle_url = '';
if ($enquiry->reason && $enquiry->reason instanceof \Mtc\MercuryDataModels\Vehicle) {
    $vehicle_url = \App\Facades\Site::vehicleUrl($enquiry->reason);
}

// Buttons defaults
$button_bg = '#1899C4';
$button_avocado_bg = '#8CB852';
$button_colour = '#fff';

// Buttons
$new_cars_button = View::make('vendor.crm.emails.sandown.includes.button')->with([
    'button_bg' => $button_bg,
    'button_link' => $new_cars_url,
    'button_title' => 'View all new cars',
    'button_colour' => $button_colour,
])->render();

$used_cars_button = View::make('vendor.crm.emails.sandown.includes.button')->with([
    'button_bg' => $button_bg,
    'button_link' => $used_cars_url,
    'button_title' => 'View all used cars',
    'button_colour' => $button_colour,
])->render();

$avocado_cars_button = View::make('vendor.crm.emails.sandown.includes.button')->with([
    'button_bg' => $button_avocado_bg,
    'button_link' => $new_cars_url,
    'button_title' => 'View all cars',
    'button_colour' => $button_colour,
])->render();

$reserve_button = View::make('vendor.crm.emails.sandown.includes.button')->with([
    'button_bg' => $button_bg,
    'button_link' => $vehicle_url,
    'button_title' => 'Reserve for £99',
    'button_colour' => $button_colour,
])->render();
@endphp

<!-- CONTENT AREA -->
<tr>
    <td valign="top">
        <table cellpadding="0" cellspacing="0" border="0" align="center" width="100%">
            <tr>
                <td valign="top" width="50"></td>
                <td valign="top">
                    {!! str_replace(
                        [
                            '<p>',
                            '<h1>',
                            '<h2>',
                            '<h3>',
                            '<h4>',
                            '<h5>',
                            '<h6>',
                            '<ul>',
                            '<li>',
                            '<ol>',
                            '<td>',
                            '[new-cars-button]',
                            '[used-cars-button]',
                            '[avocado-cars-button]',
                            '[reserve-button]',
                        ],
                        [
                            '<p style="color:#55595C; margin:0 0 30px; font-size:18px; font-weight:400; line-height:26px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                            '<h1 style="color:#FFFFFF !important; margin:30px 0 0; font-size:32px; font-weight:600; letter-spacing:-0.6px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                            '<h2 style="color:#55595C; margin:30px 0 10px; font-size:32px; line-height:36px; font-weight:600; letter-spacing:-0.64px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                            '<h3 style="color:#55595C; margin:30px 0 10px; font-size:24px; line-height:28px; font-weight:600; letter-spacing:-0.48px; font-family: -apple-system, BlinkMacSystemFont, avenir next, avenir, segoe ui, helvetica neue, helvetica, Cantarell, Ubuntu, roboto, noto, arial, sans-serif;">',
                            '<h4>',
                            '<h5>',
                            '<h6>',
                            '<ul>',
                            '<li>',
                            '<ol>',
                            '<td valign="top" width="20">',
                            $new_cars_button,
                            $used_cars_button,
                            $avocado_cars_button,
                            $reserve_button,
                        ],
                    $content) !!}
                </td>
                <td valign="top" width="50"></td>
            </tr>
        </table>
    </td>
</tr>
<tr>
    <td valign="top" height="50"></td>
</tr>
<!-- END OF CONTENT AREA -->