<?php

namespace App\Modules\ServiceBooking\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Modules\ServiceBooking\Http\Requests\CreateServiceDeliveryOptionRequest;
use App\Modules\ServiceBooking\Http\Requests\UpdateServiceDeliveryOptionRequest;
use App\Modules\ServiceBooking\Http\Resources\ListServiceDeliveryOptions;
use App\Modules\ServiceBooking\Http\Resources\ViewServiceDeliveryOption;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Mtc\MercuryDataModels\BookingDeliveryOption;

class ServiceDeliveryController extends Controller
{
    public function index(Request $request): ListServiceDeliveryOptions
    {
        $bookings = BookingDeliveryOption::query()
            ->latest()
            ->paginate();
        return new ListServiceDeliveryOptions($bookings);
    }

    public function store(CreateServiceDeliveryOptionRequest $request): ViewServiceDeliveryOption
    {
        $delivery = BookingDeliveryOption::query()->create($request->validated());
        return new ViewServiceDeliveryOption($delivery);
    }

    public function show(BookingDeliveryOption $delivery): ViewServiceDeliveryOption
    {
        return new ViewServiceDeliveryOption($delivery);
    }

    public function update(
        UpdateServiceDeliveryOptionRequest $request,
        BookingDeliveryOption $delivery
    ): ViewServiceDeliveryOption {
        $delivery->update($request->validated());
        return new ViewServiceDeliveryOption($delivery);
    }

    public function destroy(BookingDeliveryOption $delivery): Response
    {
        $delivery->delete();
        return \response('ok');
    }
}
