<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Mtc\MercuryDataModels\SeoData;

class SeoDataExport implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        return SeoData::query()
            ->select(['path', 'title', 'description', 'heading'])
            ->get();
    }

    /**
     * Export file heading row
     *
     * @return string[]
     */
    public function headings(): array
    {
        return [
            'path',
            'title',
            'description',
            'heading'
        ];
    }
}
