<?php

namespace App\Http\Requests;

use App\Rules\UniqueVehicleRegistrationNumber;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class AddVehicleRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required_without:registration_number',
            'registration_number' => [
                'required_without:title',
                new UniqueVehicleRegistrationNumber(),
            ],
        ];
    }
}
