<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Mtc\MercuryDataModels\Dealership;
use Mtc\MercuryDataModels\NewCar;
use Mtc\MercuryDataModels\Page;
use Mtc\MercuryDataModels\Property;
use Mtc\MercuryDataModels\Vehicle;
use Mtc\MercuryDataModels\VehicleOffer;

class BulkDeleteRequest extends FormRequest
{
    public static array $allowedModels = [
        'vehicles' => Vehicle::class,
        'new-cars' => NewCar::class,
        'offers' => VehicleOffer::class,
        'dealerships' => Dealership::class,
        'properties' => Property::class,
        'pages' => Page::class,
    ];

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'model' => 'required|string|in:' . implode(',', array_keys(self::$allowedModels)),
            'ids' => 'required|array',
            'ids.*' => 'integer',
        ];
    }

    public function getClass()
    {
        return self::$allowedModels[$this->input('model')];
    }
}
