<?php

namespace Tests\Tenant;

use Tests\TenantTestCase;
use Mtc\ContentManager\Models\Media;
use Mtc\ContentManager\Models\MediaUse;
use Illuminate\Support\Facades\Artisan;

class BulkDeleteCarAndDrivingImagesTest extends TenantTestCase
{

    public function testBulkDeleteCarAndDrivingImages()
    {
        $media1 = Media::factory()->create([
            'image_provider' => 'car-and-driving',
            'src' => 'car-driving-1.jpg'
        ]);
        $media2 = Media::factory()->create([
            'image_provider' => 'car-and-driving', 
            'src' => 'car-driving-2.jpg'
        ]);
        $media3 = Media::factory()->create([
            'image_provider' => 'other-provider'
        ]);

        $mediaUse1 = MediaUse::factory()->create(['media_id' => $media1->id]);
        $mediaUse2 = MediaUse::factory()->create(['media_id' => $media2->id]);
        $mediaUse3 = MediaUse::factory()->create(['media_id' => $media3->id]);
 
        Artisan::call('car-and-driving:bulk-delete-images');
 
        $this->assertDatabaseMissing('media', ['id' => $media1->id]);
        $this->assertDatabaseMissing('media', ['id' => $media2->id]);
        $this->assertDatabaseHas('media', ['id' => $media3->id]);

        $this->assertDatabaseMissing('media_uses', ['id' => $mediaUse1->id]);
        $this->assertDatabaseMissing('media_uses', ['id' => $mediaUse2->id]);
        $this->assertDatabaseHas('media_uses', ['id' => $mediaUse3->id]);
    }
}
