<?php

namespace App\Console\Commands;

use App\Facades\Settings;
use App\Jobs\CreateAIVehicleDescriptions;
use App\Services\OpenAI;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Validation\ValidationException;
use Mtc\MercuryDataModels\Vehicle;

class GenerateBulkVehiclesOpenAIDescriptions extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'open-ai:generate-bulk-vehicles-description {--retry}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate bulk vehicle descriptions using OpenAI';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        if (!Settings::get('open-ai-enabled') || empty(Settings::get('open-ai-api_key'))) {
            $this->info('Empty Open AI Api Key');
            return 0;
        }

        $this->dispatchSync(new CreateAIVehicleDescriptions($this->option('retry')));

        $this->info('Descriptions generated successfully.');
        return 0;
    }
}
