<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\MercuryDataModels\VehicleMake;

class LeaseMakeController extends Controller
{
    public function index(Request $request)
    {
        return response([
            'makes' => VehicleMake::query()
                ->orderBy('name')
                ->paginate($request->has('limit') ? $request->input('limit') : 100),
        ]);
    }

    public function update(Request $request)
    {
        collect($request->input('makes'))->each(function ($make) {
            VehicleMake::query()
                ->where('id', $make['make_id'])
                ->update([
                    'import_enabled' => $make['import_enabled']
                ]);
        });
    }
}
