<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Mtc\MercuryDataModels\VehicleMake;
use Mtc\MercuryDataModels\VehicleModel;

class LeaseModelController extends Controller
{
    public function index(Request $request, ?int $make_id = null)
    {
        return response([
            'models' => VehicleModel::query()
                ->when($make_id, fn($query) => $query->where('make_id', $make_id))
                ->whereHas('make', fn($make) => $make->where('import_enabled', true))
                ->orderBy('name')
                ->paginate($request->has('limit') ? $request->input('limit') : 100),
            'makes' => VehicleMake::query()
                ->where('import_enabled', true)
                ->orderBy('name')
                ->get(),
        ]);
    }

    public function update(Request $request)
    {
        collect($request->input('models'))->each(function ($model) {
            VehicleModel::query()
                ->where('id', $model['model_id'])
                ->update([
                    'import_enabled' => $model['import_enabled']
                ]);
        });
    }
}
