<?php

namespace App\Traits;

use App\Events\VehiclePriceChangedDuringStockSync;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Event;
use Mtc\MercuryDataModels\Vehicle;

trait StockSyncTraits
{
    use MapsTaxonomies;

    private function priceChangeEvents(Vehicle $vehicle, string $provider): void
    {
        Event::dispatch(new VehiclePriceChangedDuringStockSync($vehicle, $provider));
    }

    private function removeOld(Collection $allRecords): void
    {
        Vehicle::query()
            ->where('stock_provider', self::NAME)
            ->whereNotIn('uuid', $allRecords)
            ->delete();
    }

    private function removeNotSynced(bool $check_pending = true): void
    {
        Vehicle::query()
            ->where('stock_provider', $this->getProviderName())
            ->where('was_recently_synced', 0)
            ->when($check_pending, fn ($query) => $query->whereNull('pending_stock_sync'))
            ->delete();
    }
}
