<?php

namespace App\Http\Controllers;

use Illuminate\Http\Response;
use Mtc\MercuryDataModels\VehicleModel;

class ModelController extends Controller
{
    /**
     * Display a listing of body vehicle model
     *
     * @param int $make_id
     * @return Response
     */
    public function index($make_id): Response
    {
        return response([
            'data' => VehicleModel::query()
                ->with('filterIndex')
                ->ofMake($make_id)
                ->orderBy('name')
                ->get()
        ]);
    }

    /**
     * Display the specified vehicle model.
     *
     * @param  VehicleModel $model
     * @return VehicleModel
     */
    public function show(VehicleModel $model)
    {
        return $model;
    }
}
