<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class StormEnquiryListResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'links' => [
                'self' => [
                    'link' => $this->resource
                        ->map(fn($enquiry) => url('/api/v1/storm/' . tenant('id') . '/enquiries/' . $enquiry->id))
                        ->toArray(),
                ],
            ],
        ];
    }
}
