<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class NewVehicleMakesModelsMail extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(
        private readonly Collection $recentMakes,
        private readonly Collection $recentModels,
    ) {
        //
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('system.new_vehicles', [
            'recentMakes' => $this->recentMakes,
            'recentModels' => $this->recentModels,
        ])->subject('New makes/models added to system ' . config('app.name'));
    }
}
