<?php

namespace App;

use App\Contracts\InteractsWithContentSync;
use Mtc\ContentManager\Models\MediaSize;

class MediaSizeRepository implements InteractsWithContentSync
{
    public function importRecord(array $entry): bool
    {
        $mediaSize = MediaSize::query()->create($entry);

        return $mediaSize->exists;
    }

    public function canBeImported(array $entry): bool
    {
        return !MediaSize::query()
            ->where('label', $entry['label'])
            ->where('model', $entry['model'])
            ->exists();
    }

    public function exportToRemote(array $selections): array
    {
        return MediaSize::query()->newQuery()
            ->select(['label', 'model', 'width', 'height'])
            ->whereIn('id', $selections)
            ->get()
            ->toArray();
    }

    public function checkImportEntryValidity(array $dataEntry, array $allEntries): array
    {
        $slug = $dataEntry['model'] . ': ' . $dataEntry['label'];
        $mediaSizeExists = MediaSize::query()
            ->where('label', $dataEntry['label'])
            ->where('model', $dataEntry['model'])
            ->exists();

        $errors = [];
        if (empty($dataEntry['label']) || empty($dataEntry['model'])) {
            $errors[] = __('validation.import_slug_missing', ['slug' => $slug]);
        } elseif ($mediaSizeExists) {
            $errors[] = __('validation.import_slug_taken', ['slug' => $slug]);
        }

        return [
            'data' => $dataEntry,
            'errors' => $errors,
        ];
    }
}
