<?php

namespace App\Modules\SalesChannels;

use App\Contracts\SalesChannel;
use App\Facades\Settings;
use App\Jobs\PhyronExportJob;
use Illuminate\Foundation\Bus\DispatchesJobs;

class Phyron implements SalesChannel
{
    use DispatchesJobs;

    /**
     * Check if channel is enabled
     *
     * @return bool
     */
    public function enabled(): bool
    {
        return (bool)Settings::get('sales-channels-phyron-enabled');
    }

    public function name(): string
    {
        return __('sales_channels.phyron');
    }

    /**
     * Run a scheduled export
     *
     * @return void
     */
    public function runScheduledExport(): void
    {
        if ($this->enabled()) {
            $this->dispatch(new PhyronExportJob());
        }
    }

    /**
     * Fields to add to dealership management
     *
     * @return array[]
     */
    public function dealershipAdditionalDataFields()
    {
        return [
            'phyron-dealer-id' => [
                'type' => 'text',
                'label' => 'Dealership ID on Phyron'
            ],
        ];
    }
}
