<?php

namespace App;

use App\Services\GraphService;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\App;

class ReportRepository
{
    /**
     * Get the key metrics for dashboard
     *
     * @return Collection
     */
    public function getStats(): Collection
    {
        return collect(config('reports.dashboard_stats', []))
            ->map(fn ($stats_class) => App::make($stats_class))
            ->values();
    }

    /**
     * Get the dashboard tiles.
     *
     * @return Collection
     */
    public function getTiles(string $type = 'dashboard'): Collection
    {
        return match ($type) {
            'dashboard' => collect(config('reports.dashboard_tiles', []))
                ->map(fn ($tile_class) => App::make($tile_class))
                ->values(),
            'crm' => collect(config('reports.crm_tiles', []))
                ->map(fn ($tile_class) => App::make($tile_class))
                ->values(),
            default => collect([]),
        };
    }

    public function getGraph(): array
    {
        return (new GraphService())->getGraph();
    }
}
