<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class AutoTraderStockPublishedSyncSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'AutoTrader',
                'group' => 'Stock pull from AutoTrader to website',
                'name' => 'Sync published status',
                'config_key' => 'auto-trader-sync-is-published',
                'type' => 'boolean',
                'min_tier' => 'standard',
                'value' => true,
                'description' => 'When enabled will not sync published status to be in sync with AutoTrader',
            ],
        ];
    }
}
