<?php

namespace App\Console\Commands;

use App\Master\LoginService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\App;
use Symfony\Component\Console\Command\Command as SymfonyCommand;

class MtcOldStaffCheck extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mtc:verify-staff';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Make sure old mtc staff members are removed from authentication';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(protected LoginService $loginService)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $emails = App::make(config('auth.providers.users.model'))->newQuery()
            ->where('email', 'like', '%@mtcmedia.co.uk')
            ->orWhere('email', 'like', '%@mtc.co.uk')
            ->pluck('email')
            ->toArray();

        $oldEmails = $this->loginService->filterOldUsers($emails);

        App::make(config('auth.providers.users.model'))->newQuery()
            ->whereIn('email', $oldEmails)
            ->delete();

        return SymfonyCommand::SUCCESS;
    }
}
