<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class VehicleFilterFeaturesOnSRPSettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Filter',
                'group' => 'General',
                'name' => 'Show vehicle features on vehicle card',
                'config_key' => 'automotive-vehicle-features-on-filter-card',
                'type' => 'boolean',
                'value' => false,
            ],
        ];
    }
}
