<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Mtc\MercuryDataModels\Vehicle;

class FixMissingVRMCondensedValues extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'fix:vrm-condensed-values';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fix vehicles not having vrm_condensed values';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        Vehicle::query()
            ->whereNull('vrm_condensed')
            ->whereNotNull('registration_number')
            ->get()
            ->each(fn(Vehicle $vehicle) => $vehicle->update([
                'vrm_condensed' => str_replace(' ', '', $vehicle->registration_number),
            ]));
    }
}
