<?php

namespace App\Console\Commands;

use App\Jobs\RunLeaseDataSyncJob;
use Illuminate\Console\Command;
use Illuminate\Foundation\Bus\DispatchesJobs;

class SyncLeaseData extends Command
{
    use DispatchesJobs;

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sync:lease-data';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Sync lease data for tenant from leasing data providers';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->dispatch(new RunLeaseDataSyncJob());
        return 0;
    }
}
