<?php

namespace App\Http\Resources;

use App\NewCarRepository;
use App\OfferRepository;
use App\PageRepository;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Contracts\PageModel;
use Mtc\MercuryDataModels\NewCar;

class TemplateUsageListResource extends JsonResource
{
    public static $wrap = '';
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    private PageRepository $pageRepository;
    private OfferRepository $offerRepository;
    private NewCarRepository $newCarRepository;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        if ($this->resource instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator) {
            $this->resource
                ->through(fn(Model $entry) => $this->mapRecord($entry));
        } else {
            $this->resource = $this->resource
                ->map(fn(Model $entry) => $this->mapRecord($entry));
        }
        return parent::toArray($request);
    }

    /**
     * Map template record
     *
     * @param Model $page
     * @return array
     */
    protected function mapRecord(Model $entry)
    {
        if ($entry instanceof PageModel) {
            return [
                'id' => $entry->id,
                'title' => $entry->title,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/content/edit/' . $entry->id,
                'type' => 'page',
                'in_sync' => $this->pageRepository()->isContentOutOfSync($entry) !== true,
            ];
        }

        if ($entry instanceof NewCar) {
            return [
                'id' => $entry->id,
                'title' => $entry->name,
                'updated_at' => $entry->updated_at->diffForHumans(),
                'url' => '/manage-content/new-vehicles/edit/' . $entry->id,
                'type' => 'new car',
                'in_sync' => $this->newCarRepository()->isContentOutOfSync($entry) !== true,
            ];
        }

        return [
            'id' => $entry->id,
            'title' => $entry->name,
            'updated_at' => $entry->updated_at->diffForHumans(),
            'url' => '/manage-content/offers/edit/' . $entry->id,
            'type' => 'offer',
            'in_sync' => $this->offerRepository()->isContentOutOfSync($entry) !== true
        ];
    }

    private function pageRepository(): PageRepository
    {
        if (!isset($this->pageRepository)) {
            $this->pageRepository = App::make(PageRepository::class);
        }

        return $this->pageRepository;
    }

    private function offerRepository(): OfferRepository
    {

        if (!isset($this->offerRepository)) {
            $this->offerRepository = App::make(OfferRepository::class);
        }

        return $this->offerRepository;
    }

    private function newCarRepository(): NewCarRepository
    {
        if (!isset($this->newCarRepository)) {
            $this->newCarRepository = App::make(NewCarRepository::class);
        }

        return $this->newCarRepository;
    }
}
