<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class CodeweaversNewVehicleWidgetSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'CodeWeavers',
                'name' => 'Allow finance calculator for new vehicles',
                'config_key' => 'sales-codeweavers-widget-enabled-for-new-vehicles',
                'type' => 'boolean',
                'value' => false,
            ]
        ];
    }
}
