<?php

namespace App\Http\Resources;

use App\Contracts\GoLiveChecklist;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\App;

class SiteGoLiveResource extends JsonResource
{
    public static $wrap = '';
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $this->resource->load([
            'billables',
            'features',
        ]);

        $resource = $this->resource->toArray();
        $resource['cloudflare_data'] = [
            'zone_id' => $this->resource->cloudflare_data['zone_id'] ?? null,
            'email' => $this->resource->cloudflare_data['email'] ?? null,
            'key' => $this->resource->cloudflare_data['key'] ?? null,
        ];
        $resource['enabled_features'] = $this->resource->features->pluck('feature');



        $resource['go_live_tasks'] = collect(config('app.go_live_checklist', []))
            ->map(fn($checklistClass) => App::make($checklistClass))
            ->filter(fn($checklist) => $checklist instanceof GoLiveChecklist)
            ->map(fn(GoLiveChecklist $checklist, $name) => [
                'id' => $checklist->key(),
                'name' => $checklist->name(),
                'status' => $checklist->status(),
                'status_icon' => $checklist->statusIcon(),
                'manual_confirm' => $checklist->requiresManualConfirm(),
                'details' => $checklist->details(),
                'category' => __('go-live.categories.' . $checklist->category()),
            ])
            ->groupBy(fn($row) => $row['category']);

        return $resource;
    }
}
