<?php

declare(strict_types=1);

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Stancl\Tenancy\Contracts\TenantWithDatabase;

class AddTemporaryDomain implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    /** @var TenantWithDatabase */
    protected $tenant;

    public function __construct(TenantWithDatabase $tenant)
    {
        $this->tenant = $tenant;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if (app()->runningUnitTests()) {
            // do not seed automatically when in tests
            return;
        }

        $domainName = str_replace('_', '-', $this->tenant->id) . '.' . config('app.tenant_temp_domain_base');

        $this->tenant->domains()
            ->create([
                'primary' => true,
                'verified' => true,
                'domain' => $domainName
            ]);
    }
}
