<?php

namespace App\Services;

class LocatingService extends \Mtc\MercuryDataModels\Services\LocatingService
{
    /**
     * Calculate the distance between two sets of coordinates
     *
     * @param float $lat1
     * @param float $lon1
     * @param float $lat2
     * @param float $lon2
     * @param string $unit
     * @return float
     */
    public function getDistanceBetween(float $lat1, float $lon1, float $lat2, float $lon2, string $unit = 'mi'): float
    {
        $theta = $lon1 - $lon2;
        $dist = sin(deg2rad($lat1))
            * sin(deg2rad($lat2))
            + cos(deg2rad($lat1))
            * cos(deg2rad($lat2))
            * cos(deg2rad($theta));
        $dist = acos($dist);
        $dist = rad2deg($dist);
        $miles = $dist * 60 * 1.1515;

        if (strtolower($unit) == 'km') {
            return ($miles * 1.609344);
        }

        return $miles;
    }
}
