<?php

namespace Database\Seeders\Tenant;

use App\Facades\Settings;
use Illuminate\Database\Seeder;

class AdvancedFinanceSettingsSeed extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        collect($this->data())
            ->each(fn($setting) => Settings::make($setting));
    }

    private function data(): array
    {
        return [
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'iVendi',
                'name' => 'Enable individual dealer keys',
                'config_key' => 'finance-per-dealer-keys',
                'min_tier' => 'pro',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Finance integration keys set per dealer with master as fallback.',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'iVendi',
                'name' => 'Enable credit rating based pricing',
                'config_key' => 'finance-risk-based-pricing-enabled',
                'min_tier' => 'pro',
                'type' => 'boolean',
                'value' => false,
                'description' => 'Enable finance requests to allow risk-based calculations',
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'iVendi',
                'name' => 'Allow Electric vehicles for risk based pricing',
                'config_key' => 'finance-risk-based-pricing-allow-electric',
                'min_tier' => 'pro',
                'type' => 'boolean',
                'value' => false,
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'iVendi',
                'name' => 'Risk based pricing - finance option restricted',
                'config_key' => 'finance-risk-based-pricing-enable-finance-options',
                'min_tier' => 'enterprise',
                'type' => 'boolean',
                'value' => '',
                'description' => 'Enable ability to restrict risk based pricing to specific finance options for vehicles'
            ],
            [
                'tab' => 'Automotive',
                'section' => 'Finance',
                'group' => 'iVendi',
                'name' => 'Risk based pricing - vehicle allowed finance options',
                'config_key' => 'finance-risk-based-pricing-finance-options',
                'min_tier' => 'enterprise',
                'type' => 'string',
                'value' => '',
                'description' => 'Comma separated values, finance options that are allowed for risk based pricing',
                'validation_rules' => [
                    "required_if:values.finance-risk-based-pricing-enable-finance-options,true"
                ],
            ],
        ];
    }
}
